# -*- Mode: Python -*-
# -*- coding: ascii -*-

import sys
import lwsdk


__author__     = "Nao_Kuris"
__date__       = "April 5 2019"
__copyright__  = "Copyright (C) 2018 Hand to Mouse."
__version__    = "3.1"
__maintainer__ = "Nao_Kuris"
__email__      = "www.hand-to-mouse.jp"
__status__     = "Layout"
__lwver__      = "2018"

from lwsdk.pris.layout.cs import selectbyname,schematicposition

class krs_load_schemaPos_py(lwsdk.IGeneric):
    def __init__(self, context):
        super(krs_load_schemaPos_py, self).__init__()
        
        from lwsdk.pris import getdir
        
        
        self._filepath = getdir('Content') + "_schematic/standard_RIG.svp"
        self._isSelectedOnly = False
        self._withColor = True
        self._isSaparator = False
        
        #get Prefix
        sel = lwsdk.LWInterfaceInfo().selected_items()[0]
        getName = lwsdk.LWItemInfo().name(sel)
        items = getName.split('-')
        if len(items) == 1:
            self._prefixStr = ""
        else:
            self._prefixStr = items[0]+"-"
            
    def boneScan(self,item,fileItemName, scPos, scCol):
        bone = lwsdk.LWItemInfo().first(lwsdk.LWI_BONE, item)
        while bone:
            self.scPosCheck(fileItemName, bone, scPos, scCol)
            bone = lwsdk.LWItemInfo().next(bone)

    def scanForItems(self,type,fileItemName, scPos, scCol):
        item = lwsdk.LWItemInfo().first(type, None)
        while(item):
            self.scPosCheck(fileItemName, item, scPos, scCol)
            if type == lwsdk.LWI_OBJECT:
                self.boneScan(item,fileItemName, scPos, scCol)
            item = lwsdk.LWItemInfo().next(item)
        
        
    #Main
    def scPosCheck(self, fileItemName, sceneItem, scPos, scCol):
        
        sceneItemName = lwsdk.LWItemInfo().name(sceneItem)
        isSplit = False
        if self._isSaparator:
            splitFName = fileItemName.split(self._prefixStr)
            if len(splitFName) != 1:
                if splitFName[0] != "":
                    fileItemName = splitFName[0]+splitFName[1]
                else:
                    fileItemName = splitFName[1]
                
            splitSName = sceneItemName.split(self._prefixStr)
            
            if len(splitSName) != 1:
                
                isSplit = True
                if splitSName[0] != "":
                    sceneItemName = splitSName[0]+splitSName[1]
                else:
                    sceneItemName = splitSName[1]
                
        
        
        if fileItemName == sceneItemName:
            selected_item_id = lwsdk.itemid_to_str(sceneItem)
            lwsdk.command("SelectItem %s" % selected_item_id)
            
            sP = scPos.split(' ')
            schematicposition(sP[0],sP[1])
            if self._withColor:
                lwsdk.LWInterfaceInfo().setItemColorIndex(sceneItem,int(scCol))

    # LWGeneric -------------------------------------------
    def process(self, ga):
        
        
        
        ui = lwsdk.LWPanels()
        title = 'Load Schema Pos v%s' %__version__
        panel = ui.create(title)

        controlWidth = 64

        c0 = panel.load_ctl('Select svp file',controlWidth)
        c1 = panel.bool_ctl('Selected Item Only')
        c2 = panel.bool_ctl('with Item Color')
        c3 = panel.bool_ctl('Ignore Specific Text')
        c4 = panel.str_ctl('Specific Text',controlWidth)
        
        c0.set_str(self._filepath)
        c1.set_int(1 if self._isSelectedOnly else 0)
        c2.set_int(1 if self._withColor else 0)
        c3.set_int(1 if self._isSaparator else 0)
        c4.set_str(self._prefixStr)
        
        if panel.open(lwsdk.PANF_BLOCKING | lwsdk.PANF_CANCEL) == 0:
            ui.destroy(panel)
            return lwsdk.AFUNC_OK
            
        self._filepath = c0.get_str()
        self._isSelectedOnly = (c1.get_int() == 1)
        self._withColor = (c2.get_int() == 1)
        self._isSaparator = (c3.get_int() == 1)
        self._prefixStr = c4.get_str()
        
        #prepare File Object
        path =  self._filepath
        lines = open(self._filepath).readlines()
        
            
        for line in lines:
            fileItems = line.split(':')
                
            if self._isSelectedOnly:
                # scan Selected
                obj = lwsdk.LWInterfaceInfo().selected_items()
                for i in obj:
                    self.scPosCheck(fileItems[0],i,fileItems[1],fileItems[2])
            else:
                # scan All
                    self.scanForItems(lwsdk.LWI_OBJECT,fileItems[0],fileItems[1],fileItems[2])
            
        return lwsdk.AFUNC_OK

ServerTagInfo = [
                    ( "krs_Load_schemaPos_py", lwsdk.SRVTAG_USERNAME | lwsdk.LANGID_USENGLISH ),
                    ( "krs_Load_schemaPos_py", lwsdk.SRVTAG_BUTTONNAME | lwsdk.LANGID_USENGLISH ),
                    ( "Utilities/Python", lwsdk.SRVTAG_MENU | lwsdk.LANGID_USENGLISH )
                ]

ServerRecord = { lwsdk.GenericFactory("LW_PYLoadSchemaPos",krs_load_schemaPos_py) : ServerTagInfo }